/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.files.resources.logs;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.ServerInfo;
import com.xwiki.admintools.download.DataResource;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.internal.files.resources.logs.LogFiles;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="logs")
@Singleton
public class LogsDataResource
implements DataResource {
    public static final String HINT = "logs";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String NO_LINES = "noLines";
    private static final String DEFAULT_NO_LINES = "1000";
    private static final String LINE_BREAK = "\n";
    @Inject
    private Logger logger;
    @Inject
    private CurrentServer currentServer;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private LogFiles logFiles;

    public String getIdentifier() {
        return HINT;
    }

    public byte[] getByteData(Map<String, String[]> params) throws IOException, NumberFormatException {
        try {
            String osName;
            ServerInfo usedServer = this.currentServer.getCurrentServer();
            if (usedServer == null) {
                throw new NullPointerException("Server not found! Configure path in extension configuration.");
            }
            int linesCount = this.getRequestedLines(params);
            if (linesCount > 50000) {
                linesCount = 50000;
            }
            if ((osName = System.getProperty("os.name").toLowerCase()).contains("linux")) {
                return this.getLinuxByteData(usedServer, linesCount);
            }
            if (osName.contains("windows")) {
                return this.getWindowsByteData(usedServer, linesCount);
            }
            throw new RuntimeException("OS not supported!");
        }
        catch (IOException exception) {
            throw new IOException(String.format("Error while accessing log files at [%s].", this.currentServer.getCurrentServer().getLastLogFilePath()), exception);
        }
        catch (NumberFormatException exception) {
            throw new NumberFormatException(String.format("The given [%s] lines number is not a valid number.", params.get(NO_LINES)[0]));
        }
    }

    public void addZipEntry(ZipOutputStream zipOutputStream, Map<String, String[]> params) {
        Map<String, String> filters = LogsDataResource.getFilters(params);
        byte[] buffer = new byte[2048];
        try {
            File logsFolder = new File(this.currentServer.getCurrentServer().getLogsFolderPath());
            File[] listOfFiles = logsFolder.listFiles();
            for (File file : listOfFiles != null ? listOfFiles : new File[]{}) {
                if (!file.isFile() || !filters.isEmpty() && !this.checkFilters(file, filters)) continue;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    int bytesRead;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    ZipEntry zipEntry = new ZipEntry("logs/" + file.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                        zipOutputStream.write(buffer, 0, bytesRead);
                    }
                    bufferedInputStream.close();
                }
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to get logs. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private byte[] getLinuxByteData(ServerInfo usedServer, int linesCount) throws IOException {
        File file = new File(usedServer.getLastLogFilePath());
        List<String> logData = this.logFiles.getLines(file, linesCount);
        Collections.reverse(logData);
        return String.join((CharSequence)LINE_BREAK, logData).getBytes();
    }

    private byte[] getWindowsByteData(ServerInfo usedServer, int requestedLines) throws IOException {
        int linesCount = requestedLines;
        File[] files = this.logFiles.getLogFiles(usedServer.getLogsFolderPath(), usedServer.getLogsHint());
        ArrayList<String> combinedLogs = new ArrayList<String>(linesCount);
        for (File file : files) {
            List<String> retrievedLines = this.logFiles.getLines(file, linesCount);
            combinedLogs.addAll(retrievedLines);
            if ((linesCount -= retrievedLines.size()) <= 0) break;
        }
        Collections.reverse(combinedLogs);
        return String.join((CharSequence)LINE_BREAK, combinedLogs).getBytes();
    }

    private static Map<String, String> getFilters(Map<String, String[]> params) {
        HashMap<String, String> filters = new HashMap<String, String>();
        if (params != null) {
            filters.put(FROM, !Objects.equals(params.get(FROM)[0], "") ? params.get(FROM)[0] : null);
            filters.put(TO, !Objects.equals(params.get(TO)[0], "") ? params.get(TO)[0] : null);
        }
        return filters;
    }

    private int getRequestedLines(Map<String, String[]> params) {
        String noLines;
        if (params == null) {
            noLines = DEFAULT_NO_LINES;
        } else {
            noLines = params.get(NO_LINES)[0];
            if (noLines == null || noLines.isEmpty()) {
                noLines = DEFAULT_NO_LINES;
            }
        }
        return Integer.parseInt(noLines);
    }

    private boolean checkFilters(File file, Map<String, String> filters) {
        Pattern pattern = this.currentServer.getCurrentServer().getLogsPattern();
        Matcher matcher = pattern.matcher(file.getName());
        if (matcher.find()) {
            XWikiContext wikiContext = (XWikiContext)this.contextProvider.get();
            XWiki xWiki = wikiContext.getWiki();
            String userDateFormat = xWiki.getXWikiPreference("dateformat", "dd-MM-yyyy", wikiContext);
            String fileDateString = matcher.group();
            LocalDate fileDate = LocalDate.parse(fileDateString);
            DateTimeFormatter filtersFormatter = DateTimeFormatter.ofPattern(userDateFormat);
            if (filters.get(FROM) != null && filters.get(TO) != null) {
                LocalDate fromDate = LocalDate.parse(filters.get(FROM), filtersFormatter);
                LocalDate toDate = LocalDate.parse(filters.get(TO), filtersFormatter);
                return fileDate.isAfter(fromDate.minusDays(1L)) && fileDate.isBefore(toDate.plusDays(1L));
            }
            if (filters.get(FROM) != null) {
                LocalDate fromDate = LocalDate.parse(filters.get(FROM), filtersFormatter);
                return fileDate.isAfter(fromDate.minusDays(1L));
            }
            if (filters.get(TO) != null) {
                LocalDate toDate = LocalDate.parse(filters.get(TO), filtersFormatter);
                return fileDate.isBefore(toDate.plusDays(1L));
            }
            return true;
        }
        return false;
    }
}

