/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.files.resources.logs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component(roles={LogFiles.class})
@Singleton
public class LogFiles {
    public List<String> getLines(File file, int requestedLines) throws IOException {
        int linesCount = requestedLines;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            long fileLength = randomAccessFile.length();
            ArrayList<String> logLines = new ArrayList<String>();
            for (long startPosition = fileLength - 1L; startPosition > 0L && linesCount > 0; --startPosition) {
                randomAccessFile.seek(startPosition - 1L);
                int currentByte = randomAccessFile.read();
                if (currentByte != 10 && currentByte != 13) continue;
                logLines.add(randomAccessFile.readLine());
                --linesCount;
            }
            ArrayList<String> arrayList = logLines;
            return arrayList;
        }
    }

    public File[] getLogFiles(String directoryPath, String specificLogsHint) {
        File folder = new File(directoryPath);
        File[] files = folder.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        files = (File[])Arrays.stream(files).filter(file -> file.getName().startsWith(specificLogsHint)).toArray(File[]::new);
        Arrays.sort(files, Comparator.comparing(File::getName).reversed());
        return files;
    }
}

