/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.files.resources;

import com.xwiki.admintools.ServerInfo;
import com.xwiki.admintools.configuration.AdminToolsConfiguration;
import com.xwiki.admintools.download.DataResource;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="xwikiConfig")
@Singleton
public class XWikiConfigFileDataResource
implements DataResource {
    public static final String HINT = "xwikiConfig";
    private static final String XWIKI_CFG = "xwiki.cfg";
    @Inject
    @Named(value="default")
    private AdminToolsConfiguration adminToolsConfig;
    @Inject
    private CurrentServer currentServer;
    @Inject
    private Logger logger;

    public void addZipEntry(ZipOutputStream zipOutputStream, Map<String, String[]> filters) {
        this.addZipEntry(zipOutputStream);
    }

    public byte[] getByteData(Map<String, String[]> params) throws IOException {
        byte[] byArray;
        ServerInfo usedServer = this.currentServer.getCurrentServer();
        if (usedServer == null) {
            throw new NullPointerException("Server not found! Configure path in extension configuration.");
        }
        List excludedLinesHints = this.adminToolsConfig.getExcludedLines();
        String filePath = usedServer.getXwikiCfgFolderPath() + XWIKI_CFG;
        File inputFile = new File(filePath);
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        try {
            String currentLine;
            StringBuilder stringBuilder = new StringBuilder();
            while ((currentLine = reader.readLine()) != null) {
                String trimmedLine = currentLine.trim();
                if (excludedLinesHints.stream().anyMatch(trimmedLine::contains)) continue;
                stringBuilder.append(currentLine).append(System.getProperty("line.separator"));
            }
            reader.close();
            byArray = stringBuilder.toString().getBytes();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IOException(String.format("Error while handling [%s] file.", XWIKI_CFG), exception);
            }
        }
        reader.close();
        return byArray;
    }

    public String getIdentifier() {
        return HINT;
    }

    private void addZipEntry(ZipOutputStream zipOutputStream) {
        try {
            byte[] buffer = this.getByteData(null);
            ZipEntry zipEntry = new ZipEntry(XWIKI_CFG);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(buffer, 0, buffer.length);
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            this.logger.warn("Could not add {} to the archive. Root cause is: [{}]", (Object)XWIKI_CFG, (Object)ExceptionUtils.getRootCauseMessage((Throwable)exception));
        }
    }
}

