/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.data.identifiers;

import com.xwiki.admintools.internal.data.identifiers.AbstractServerInfo;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="tomcat")
@Singleton
public class TomcatInfo
extends AbstractServerInfo {
    public static final String HINT = "tomcat";
    private static final String ETC_XWIKI_INSTALL = "/etc/xwiki/";

    public boolean foundServerPath() {
        this.serverPath = null;
        String providedConfigServerPath = this.adminToolsConfig.getServerPath();
        if (providedConfigServerPath != null && !providedConfigServerPath.isEmpty()) {
            return this.checkAndSetServerPath(providedConfigServerPath);
        }
        String catalinaBase = System.getProperty("catalina.base");
        String catalinaHome = System.getenv("CATALINA_HOME");
        if (catalinaBase != null && !catalinaBase.isEmpty()) {
            return this.checkAndSetServerPath(catalinaBase);
        }
        if (catalinaHome != null && !catalinaHome.isEmpty()) {
            return this.checkAndSetServerPath(catalinaHome);
        }
        return false;
    }

    public String getComponentHint() {
        return HINT;
    }

    public void updatePossiblePaths() {
        this.serverCfgPossiblePaths = List.of(String.format("%s/conf/server.xml", this.serverPath), "/usr/local/tomcat/conf/server.xml", "/opt/tomcat/conf/server.xml", "/var/lib/tomcat8/conf/server.xml", "/var/lib/tomcat9/conf/server.xml", "/var/lib/tomcat/conf/server.xml");
        this.xwikiCfgPossiblePaths = List.of(String.format("%s/WEB-INF/", this.getXWikiInstallFolderPath()), String.format("%s/", this.getXWikiInstallFolderPath()), String.format("%s/webapps/xwiki/WEB-INF/", this.serverPath), String.format("%s/webapps/ROOT/WEB-INF/", this.serverPath), ETC_XWIKI_INSTALL, "/usr/local/xwiki/WEB-INF/", "/opt/xwiki/WEB-INF/");
        this.xwikiInstallPossiblePaths = List.of(String.format("%s/webapps/xwiki/", this.serverPath), ETC_XWIKI_INSTALL, "/usr/local/xwiki/", "/opt/xwiki/");
    }

    public String getLogsFolderPath() {
        return this.serverPath + "/logs";
    }

    public String getLastLogFilePath() {
        return this.serverPath + "/logs/catalina.out";
    }

    public String getLogsHint() {
        return "catalina";
    }

    public Pattern getLogsPattern() {
        return Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    }

    private boolean checkAndSetServerPath(String path) {
        File file = new File(path + "/conf/catalina.properties");
        if (file.exists()) {
            this.serverPath = path;
            return true;
        }
        return false;
    }
}

