/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.data.identifiers;

import com.xwiki.admintools.ServerInfo;
import com.xwiki.admintools.internal.usage.UsageDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;

@Component(roles={CurrentServer.class})
@Singleton
public class CurrentServer
implements Initializable {
    private static final String SERVER_NAME_KEY = "name";
    @Inject
    private Provider<List<ServerInfo>> supportedServers;
    @Inject
    private UsageDataProvider usageDataProvider;
    private ServerInfo currentServerInfo;

    public void initialize() throws InitializationException {
        this.updateCurrentServer();
    }

    public ServerInfo getCurrentServer() {
        return this.currentServerInfo;
    }

    public List<String> getSupportedDBs() {
        return List.of("MySQL", "HSQL", "MariaDB", "PostgreSQL", "Oracle");
    }

    public List<String> getSupportedServers() {
        ArrayList<String> supportedServerList = new ArrayList<String>();
        for (ServerInfo serverInfo : (List)this.supportedServers.get()) {
            supportedServerList.add(serverInfo.getComponentHint());
        }
        return supportedServerList;
    }

    public void updateCurrentServer() {
        this.currentServerInfo = null;
        for (ServerInfo serverInfo : (List)this.supportedServers.get()) {
            boolean matchingHint = this.usageDataProvider.getServerMetadata().get(SERVER_NAME_KEY).toLowerCase().contains(serverInfo.getComponentHint());
            if (!matchingHint || !serverInfo.foundServerPath()) continue;
            this.currentServerInfo = serverInfo;
            this.currentServerInfo.updatePossiblePaths();
            break;
        }
    }
}

