/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.data;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.ServerInfo;
import com.xwiki.admintools.internal.data.AbstractDataProvider;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.internal.usage.UsageDataProvider;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="configuration")
@Singleton
public class ConfigurationDataProvider
extends AbstractDataProvider {
    public static final String HINT = "configuration";
    private static final String TEMPLATE_NAME = "configurationTemplate.vm";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_VERSION = "version";
    @Inject
    private CurrentServer currentServer;
    @Inject
    private UsageDataProvider usageDataProvider;

    public String getIdentifier() {
        return HINT;
    }

    public String getRenderedData() {
        Map<Object, Object> systemInfo = new HashMap();
        try {
            systemInfo = this.getDataAsJSON();
            systemInfo.put("serverFound", "true");
        }
        catch (Exception e) {
            this.logger.warn("Failed to generate the instance configuration data. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            systemInfo.put("serverFound", "false");
        }
        return this.renderTemplate(TEMPLATE_NAME, systemInfo, HINT);
    }

    public Map<String, String> getDataAsJSON() throws Exception {
        try {
            HashMap<String, String> systemInfo = new HashMap<String, String>();
            Map<String, String> dbMetadata = this.usageDataProvider.getDatabaseMetadata();
            systemInfo.put("databaseName", dbMetadata.get(METADATA_NAME));
            systemInfo.put("databaseVersion", dbMetadata.get(METADATA_VERSION));
            systemInfo.put("xwikiCfgPath", this.getCurrentServer().getXwikiCfgFolderPath());
            systemInfo.put("xwikiInstallPath", this.getCurrentServer().getXWikiInstallFolderPath());
            systemInfo.put("serverPath", this.getCurrentServer().getServerPath());
            systemInfo.put("logsFolderPath", this.getCurrentServer().getLogsFolderPath());
            systemInfo.put("tomcatConfPath", this.getCurrentServer().getServerCfgPath());
            systemInfo.put("javaVersion", this.getJavaVersion());
            Map<String, String> serverMetadata = this.usageDataProvider.getServerMetadata();
            systemInfo.put("usedServerName", serverMetadata.get(METADATA_NAME));
            systemInfo.put("usedServerVersion", serverMetadata.get(METADATA_VERSION));
            systemInfo.put("xwikiVersion", this.getXWikiVersion());
            systemInfo.putAll(this.getOSInfo());
            return systemInfo;
        }
        catch (Exception e) {
            throw new Exception("Failed to generate the instance configuration data.", e);
        }
    }

    private String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private Map<String, String> getOSInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("osName", System.getProperty("os.name"));
        result.put("osVersion", System.getProperty("os.version"));
        result.put("osArch", System.getProperty("os.arch"));
        return result;
    }

    private ServerInfo getCurrentServer() {
        ServerInfo serverInfo = this.currentServer.getCurrentServer();
        if (serverInfo == null) {
            throw new NullPointerException("Failed to retrieve the current used server, check your configurations.");
        }
        return serverInfo;
    }

    private String getXWikiVersion() {
        XWikiContext wikiContext = (XWikiContext)this.xcontextProvider.get();
        XWiki xWiki = wikiContext.getWiki();
        return xWiki.getVersion();
    }
}

