/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.configuration;

import com.xwiki.admintools.configuration.AdminToolsConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;

@Component
@Singleton
public class DefaultAdminToolsConfiguration
implements AdminToolsConfiguration {
    private static final String SERVER_LOCATION = "serverLocation";
    private static final String EXCLUDED_LINES = "excludedLines";
    private static final String SPAM_SIZE = "spamSize";
    private static final String XWIKI_INSTALL_LOCATION = "xwikiInstallLocation";
    @Inject
    @Named(value="admintools.configuration.current")
    private ConfigurationSource mainConfiguration;

    public String getServerPath() {
        return (String)this.mainConfiguration.getProperty(SERVER_LOCATION, (Object)"");
    }

    public List<String> getExcludedLines() {
        return new ArrayList<String>(List.of(((String)this.mainConfiguration.getProperty(EXCLUDED_LINES, (Object)"NO_EXCLUDED_LINE")).split(",")));
    }

    public int getSpamSize() {
        return Integer.parseInt((String)this.mainConfiguration.getProperty(SPAM_SIZE, (Object)"50"));
    }

    public String getXWikiInstallLocation() {
        return (String)this.mainConfiguration.getProperty(XWIKI_INSTALL_LOCATION, (Object)"");
    }
}

