/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal;

import com.xwiki.admintools.DataProvider;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.internal.files.ImportantFilesManager;
import com.xwiki.admintools.internal.usage.InstanceUsageManager;
import com.xwiki.admintools.internal.usage.wikiResult.WikiRecycleBins;
import com.xwiki.admintools.internal.usage.wikiResult.WikiSizeResult;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.common.SolrDocumentList;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

@Component(roles={AdminToolsManager.class})
@Singleton
public class AdminToolsManager {
    @Inject
    private Provider<List<DataProvider>> dataProviderProvider;
    @Inject
    private CurrentServer currentServer;
    @Inject
    private ImportantFilesManager importantFilesManager;
    @Inject
    private InstanceUsageManager instanceUsageManager;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;

    public String generateData() {
        StringBuilder strBuilder = new StringBuilder();
        for (DataProvider dataProvider : (List)this.dataProviderProvider.get()) {
            strBuilder.append(dataProvider.getRenderedData());
            strBuilder.append("\n");
        }
        return strBuilder.toString();
    }

    public String generateData(String hint) throws ComponentLookupException {
        DataProvider dataProvider = (DataProvider)this.contextComponentManager.getInstance(DataProvider.class, hint);
        return dataProvider.getRenderedData();
    }

    public List<String> getSupportedDBs() {
        return this.currentServer.getSupportedDBs();
    }

    public List<String> getSupportedServers() {
        return this.currentServer.getSupportedServers();
    }

    public String getFilesSection() {
        return this.importantFilesManager.renderTemplate();
    }

    public String getInstanceSizeTemplate() {
        return this.instanceUsageManager.renderTemplate();
    }

    public SolrDocumentList getPagesOverGivenNumberOfComments(long maxComments, Map<String, String> filters, String order) {
        return this.instanceUsageManager.getSpammedPages(maxComments, filters, order);
    }

    public List<WikiRecycleBins> getWikisRecycleBinsSize(Map<String, String> filters, String sortColumn, String order) {
        return this.instanceUsageManager.getWikisRecycleBinsData(filters, sortColumn, order);
    }

    public List<WikiSizeResult> getWikiSizeResults(Map<String, String> filters, String sortColumn, String order) {
        return this.instanceUsageManager.getWikisSize(filters, sortColumn, order);
    }

    public SolrDocumentList getEmptyDocuments(Map<String, String> filters, String order) {
        return this.instanceUsageManager.getEmptyDocuments(filters, order);
    }
}

