/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage;

import com.xwiki.admintools.internal.usage.AbstractInstanceUsageProvider;
import com.xwiki.admintools.internal.usage.wikiResult.WikiSizeResult;
import com.xwiki.admintools.usage.WikiUsageResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.PingDataProvider;
import org.xwiki.activeinstalls2.internal.data.DatabasePing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.manager.WikiManagerException;

@Component(roles={UsageDataProvider.class})
@Singleton
public class UsageDataProvider
extends AbstractInstanceUsageProvider {
    private static final String METADATA_NAME = "name";
    private static final String METADATA_VERSION = "version";
    @Inject
    @Named(value="database")
    private PingDataProvider databasePingDataProvider;
    @Inject
    @Named(value="servlet")
    private PingDataProvider servletPingDataProvider;
    @Inject
    @Named(value="extensions")
    private PingDataProvider extensionsPingDataProvider;
    @Inject
    @Named(value="users")
    private PingDataProvider usersPingDataProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;

    public Map<String, String> getDatabaseMetadata() {
        Ping ping = new Ping();
        this.databasePingDataProvider.provideData(ping);
        DatabasePing databasePing = ping.getDatabase();
        if (databasePing == null) {
            return new HashMap<String, String>();
        }
        return Map.of(METADATA_NAME, databasePing.getName(), METADATA_VERSION, databasePing.getVersion());
    }

    public Map<String, String> getServerMetadata() {
        Ping ping = new Ping();
        this.servletPingDataProvider.provideData(ping);
        String serverName = ping.getServletContainer().getName();
        String serverVersion = ping.getServletContainer().getVersion();
        return Map.of(METADATA_NAME, serverName, METADATA_VERSION, serverVersion);
    }

    public int getExtensionCount() {
        Ping ping = new Ping();
        this.extensionsPingDataProvider.provideData(ping);
        return ping.getExtensions().size();
    }

    public long getInstanceUsersCount() {
        Ping ping = new Ping();
        this.usersPingDataProvider.provideData(ping);
        return ping.getUsers().getTotal();
    }

    public List<WikiSizeResult> getWikisSize(Map<String, String> filters, String sortColumn, String order) throws WikiManagerException {
        ArrayList<WikiUsageResult> results = new ArrayList<WikiUsageResult>();
        Collection<WikiDescriptor> searchedWikis = this.getRequestedWikis(filters);
        searchedWikis.forEach(wikiDescriptor -> {
            try {
                WikiSizeResult wikiRecycleBinResult = this.getWikiSize((WikiDescriptor)wikiDescriptor);
                if (this.checkFilters(filters, wikiRecycleBinResult)) {
                    results.add(wikiRecycleBinResult);
                }
            }
            catch (QueryException e) {
                throw new RuntimeException(e);
            }
        });
        this.applySort(results, sortColumn, order);
        return results.stream().filter(WikiSizeResult.class::isInstance).map(WikiSizeResult.class::cast).collect(Collectors.toList());
    }

    public WikiSizeResult getWikiSize(WikiDescriptor wikiDescriptor) throws QueryException {
        WikiSizeResult wikiData = new WikiSizeResult();
        String wikiId = wikiDescriptor.getId();
        wikiData.setWikiName(wikiDescriptor.getPrettyName());
        wikiData.setUserCount(this.getWikiUserCount(wikiId));
        wikiData.setDocumentsCount(this.getWikiDocumentsCount(wikiId));
        wikiData.setAttachmentsCount(this.getWikiAttachmentsCount(wikiId));
        wikiData.setAttachmentsSize(this.getWikiAttachmentSize(wikiId));
        return wikiData;
    }

    private Long getWikiUserCount(String wikiId) throws QueryException {
        StringBuilder statement = new StringBuilder(", BaseObject as obj, IntegerProperty as prop ");
        statement.append("where doc.fullName = obj.name and obj.className = 'XWiki.XWikiUsers' and ");
        statement.append("prop.id.id = obj.id and prop.id.name = 'active' and prop.value = '1'");
        List results = this.queryManager.createQuery(statement.toString(), "hql").addFilter(this.countFilter).setWiki(wikiId).execute();
        return (Long)results.get(0);
    }

    private long getWikiDocumentsCount(String wikiId) throws QueryException {
        List results = this.queryManager.createQuery("", "xwql").setWiki(wikiId).addFilter(this.countFilter).execute();
        return (Long)results.get(0);
    }

    private Long getWikiAttachmentSize(String wikiId) throws QueryException {
        List results = this.queryManager.createQuery("select sum(attach.longSize) from XWikiAttachment attach", "xwql").setWiki(wikiId).execute();
        return (Long)results.get(0);
    }

    private Long getWikiAttachmentsCount(String wikiId) throws QueryException {
        List results = this.queryManager.createQuery("select count(attach) from XWikiAttachment attach", "xwql").setWiki(wikiId).execute();
        return (Long)results.get(0);
    }
}

