/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage;

import com.xwiki.admintools.internal.usage.AbstractInstanceUsageProvider;
import com.xwiki.admintools.internal.usage.wikiResult.WikiRecycleBins;
import com.xwiki.admintools.usage.WikiUsageResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.manager.WikiManagerException;

@Component(roles={RecycleBinsProvider.class})
@Singleton
public class RecycleBinsProvider
extends AbstractInstanceUsageProvider {
    @Inject
    private QueryManager queryManager;

    public List<WikiRecycleBins> getWikisRecycleBinsSize(Map<String, String> filters, String sortColumn, String order) throws WikiManagerException {
        Collection<WikiDescriptor> searchedWikis = this.getRequestedWikis(filters);
        ArrayList<WikiUsageResult> results = new ArrayList<WikiUsageResult>();
        searchedWikis.forEach(wikiDescriptor -> {
            try {
                WikiRecycleBins wikiRecycleBinResult = this.getWikiRecycleBinsSize((WikiDescriptor)wikiDescriptor);
                if (this.checkFilters(filters, wikiRecycleBinResult)) {
                    results.add(wikiRecycleBinResult);
                }
            }
            catch (QueryException e) {
                throw new RuntimeException(e);
            }
        });
        this.applySort(results, sortColumn, order);
        return results.stream().filter(WikiRecycleBins.class::isInstance).map(WikiRecycleBins.class::cast).collect(Collectors.toList());
    }

    public WikiRecycleBins getWikiRecycleBinsSize(WikiDescriptor wikiDescriptor) throws QueryException {
        String wikiId = wikiDescriptor.getId();
        WikiRecycleBins result = new WikiRecycleBins();
        result.setWikiName(wikiDescriptor.getPrettyName());
        result.setWikiId(wikiId);
        result.setAttachmentsCount(this.getNumberOfDeletedDocuments(wikiId, "DeletedAttachment"));
        result.setDocumentsCount(this.getNumberOfDeletedDocuments(wikiId, "XWikiDeletedDocument"));
        return result;
    }

    private long getNumberOfDeletedDocuments(String wikiID, String table) throws QueryException {
        String statement = String.format("select count(ddoc) from %s as ddoc", table);
        return (Long)this.queryManager.createQuery(statement, "xwql").setWiki(wikiID).execute().get(0);
    }
}

