/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.internal.usage.EmptyDocumentsProvider;
import com.xwiki.admintools.internal.usage.RecycleBinsProvider;
import com.xwiki.admintools.internal.usage.SpamPagesProvider;
import com.xwiki.admintools.internal.usage.UsageDataProvider;
import com.xwiki.admintools.internal.usage.wikiResult.WikiRecycleBins;
import com.xwiki.admintools.internal.usage.wikiResult.WikiSizeResult;
import com.xwiki.licensing.Licensor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.TemplateManager;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={InstanceUsageManager.class})
@Singleton
public class InstanceUsageManager {
    private static final String ERROR_TEMPLATE = "licenseError.vm";
    private static final String TEMPLATE_NAME = "wikiSizeTemplate.vm";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    private UsageDataProvider usageDataProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;
    @Inject
    private CurrentServer currentServer;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private Provider<Licensor> licensorProvider;
    @Inject
    private SpamPagesProvider spamPagesProvider;
    @Inject
    private EmptyDocumentsProvider emptyDocumentsProvider;
    @Inject
    private RecycleBinsProvider recycleBinsProvider;

    public String renderTemplate() {
        try {
            Licensor licensor = (Licensor)this.licensorProvider.get();
            String wiki = ((XWikiContext)this.xcontextProvider.get()).getWikiId();
            DocumentReference mainRef = new DocumentReference(wiki, Arrays.asList("AdminTools", "Code"), "ConfigurationClass");
            if (licensor == null || !licensor.hasLicensure((EntityReference)mainRef)) {
                return this.templateManager.render(ERROR_TEMPLATE);
            }
            ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
            boolean found = this.currentServer.getCurrentServer() != null;
            scriptContext.setAttribute("found", found, 100);
            if (!found) {
                this.logger.error("Used server not found!");
                return this.templateManager.render(TEMPLATE_NAME);
            }
            WikiDescriptor currentWikiDescriptor = this.wikiDescriptorManager.getCurrentWikiDescriptor();
            WikiSizeResult currentWiki = this.usageDataProvider.getWikiSize(currentWikiDescriptor);
            scriptContext.setAttribute("currentWikiUsage", currentWiki, 100);
            scriptContext.setAttribute("extensionCount", this.usageDataProvider.getExtensionCount(), 100);
            scriptContext.setAttribute("totalUsers", this.usageDataProvider.getInstanceUsersCount(), 100);
            return this.templateManager.render(TEMPLATE_NAME);
        }
        catch (Exception e) {
            this.logger.warn("Failed to render [{}] template. Root cause is: [{}]", (Object)TEMPLATE_NAME, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public List<WikiSizeResult> getWikisSize(Map<String, String> filters, String sortColumn, String order) {
        try {
            return this.usageDataProvider.getWikisSize(filters, sortColumn, order);
        }
        catch (Exception e) {
            this.logger.warn("There have been issues while gathering instance usage data. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public SolrDocumentList getSpammedPages(long maxComments, Map<String, String> filters, String order) {
        try {
            return this.spamPagesProvider.getDocumentsOverGivenNumberOfComments(maxComments, filters, order);
        }
        catch (Exception e) {
            this.logger.warn("There have been issues while gathering wikis spammed pages. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public SolrDocumentList getEmptyDocuments(Map<String, String> filters, String order) {
        try {
            return this.emptyDocumentsProvider.getEmptyDocuments(filters, order);
        }
        catch (Exception e) {
            this.logger.warn("There have been issues while gathering wikis empty pages. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public List<WikiRecycleBins> getWikisRecycleBinsData(Map<String, String> filters, String sortColumn, String order) {
        try {
            return this.recycleBinsProvider.getWikisRecycleBinsSize(filters, sortColumn, order);
        }
        catch (Exception e) {
            this.logger.warn("There have been issues while gathering wikis recycle bins data. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new RuntimeException(e);
        }
    }
}

