/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage;

import com.xwiki.admintools.internal.usage.AbstractInstanceUsageProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.query.SecureQuery;
import org.xwiki.search.solr.SolrUtils;

@Component(roles={EmptyDocumentsProvider.class})
@Singleton
public class EmptyDocumentsProvider
extends AbstractInstanceUsageProvider {
    private static final List<String> VALID_SORT_ORDERS = List.of("asc", "desc");
    @Inject
    @Named(value="secure")
    private QueryManager secureQueryManager;
    @Inject
    private SolrUtils solrUtils;

    public SolrDocumentList getEmptyDocuments(Map<String, String> filters, String order) throws QueryException {
        String searchedWiki;
        ArrayList<String> filterStatements = new ArrayList<String>();
        filterStatements.add("type:DOCUMENT");
        filterStatements.add("AdminTools.DocumentContentEmpty_boolean:true");
        filterStatements.add("hidden:false");
        Query query = this.secureQueryManager.createQuery("*", "solr");
        if (query instanceof SecureQuery) {
            ((SecureQuery)query).checkCurrentAuthor(true);
            ((SecureQuery)query).checkCurrentUser(true);
        }
        if ((searchedWiki = filters.get("wikiName")) != null && !searchedWiki.isEmpty() && !searchedWiki.equals("-")) {
            String searchedWikiID = searchedWiki.replace("XWikiServer", "").toLowerCase();
            filterStatements.add(String.format("wiki:%s", this.solrUtils.toCompleteFilterQueryString((Object)searchedWikiID)));
        }
        query.bindValue("fl", (Object)"title_, reference, wiki, name, spaces, AdminTools.DocumentContentEmpty_boolean, hidden");
        query.bindValue("fq", filterStatements);
        query.bindValue("sort", (Object)String.format("wiki %s", VALID_SORT_ORDERS.contains(order) ? order : VALID_SORT_ORDERS.get(0)));
        query.setLimit(100);
        return ((QueryResponse)query.execute().get(0)).getResults();
    }
}

