/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.uploadJob;

import com.xwiki.admintools.internal.uploadJob.UploadJobFileProcessor;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import com.xwiki.admintools.jobs.PackageUploadJobRequest;
import com.xwiki.admintools.jobs.PackageUploadJobStatus;
import com.xwiki.admintools.uploadPackageJob.UploadPackageJobResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.stability.Unstable;

@Component
@Named(value="admintools.uploadpackage")
@Unstable
public class UploadJob
extends AbstractJob<PackageUploadJobRequest, PackageUploadJobStatus>
implements GroupedJob {
    public static final String JOB_TYPE = "admintools.uploadpackage";
    private static final String FILE_TYPE_BACKUP = "backup";
    private static final String FILE_TYPE_TARGET = "target";
    @Inject
    private UploadJobFileProcessor fileProcessor;
    private List<UploadPackageJobResource> jobResourceList = new ArrayList<UploadPackageJobResource>();
    @Inject
    private ContextualLocalizationManager contextLocalization;

    public String getType() {
        return JOB_TYPE;
    }

    public JobGroupPath getGroupPath() {
        return new JobGroupPath(List.of("adminTools", "upload"));
    }

    protected PackageUploadJobStatus createNewStatus(PackageUploadJobRequest request) {
        return new PackageUploadJobStatus(JOB_TYPE, request, this.observationManager, this.loggerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        block12: {
            try {
                if (((PackageUploadJobStatus)this.status).isCanceled()) break block12;
                this.logger.info("Started upload job with ID: [{}]", (Object)((PackageUploadJobStatus)this.status).getJobID());
                this.progressManager.pushLevelProgress((Object)this);
                InputStream fileInputStream = this.fileProcessor.getArchiveInputStream(((PackageUploadJobRequest)this.request).getFileRef());
                try (ZipInputStream zis = new ZipInputStream(fileInputStream);){
                    ZipEntry entry;
                    this.fileProcessor.initializeBackupFolder(((PackageUploadJobStatus)this.status).getJobID());
                    while ((entry = zis.getNextEntry()) != null) {
                        if (!entry.isDirectory()) {
                            this.progressManager.startStep((Object)this);
                            UploadPackageJobResource jobResource = this.fileProcessor.maybeBackupFile(entry.getName(), (PackageUploadJobStatus)this.status);
                            this.jobResourceList.add(jobResource);
                            this.fileProcessor.processFileContent(zis, jobResource, (PackageUploadJobStatus)this.status);
                            this.progressManager.endStep((Object)this);
                        }
                        zis.closeEntry();
                    }
                }
                ((PackageUploadJobStatus)this.status).addLog(new JobResult("adminTools.jobs.upload.success", JobResultLevel.INFO, new Object[0]));
            }
            catch (Exception e) {
                this.logger.error("Error during the file upload job.", (Throwable)e);
                ((PackageUploadJobStatus)this.status).addLog(new JobResult("adminTools.jobs.upload.fail", JobResultLevel.ERROR, new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)}));
                ((PackageUploadJobStatus)this.status).addLog(new JobResult("adminTools.jobs.upload.batch.restore.start", JobResultLevel.INFO, new Object[0]));
                this.progressManager.endStep((Object)this);
                this.batchRestore();
            }
            finally {
                this.progressManager.popLevelProgress((Object)this);
                this.logger.info("Finished upload job with ID: [{}]", (Object)((PackageUploadJobStatus)this.status).getJobID());
            }
        }
    }

    private void batchRestore() {
        JobResult log;
        boolean successful = true;
        for (UploadPackageJobResource jobResource : this.jobResourceList) {
            block9: {
                this.progressManager.startStep((Object)this);
                File backupFile = jobResource.getBackupFile();
                File targetFile = jobResource.getTargetFile();
                if (backupFile == null) {
                    if (!this.handleFileDeletion(targetFile, FILE_TYPE_TARGET)) {
                        successful = false;
                        continue;
                    }
                } else {
                    try {
                        boolean backupFileDeleteFailure;
                        File newFile = Paths.get(targetFile.getParent(), new String[0]).resolve(jobResource.getNewFilename()).toFile();
                        boolean newFileDeleteFailure = !this.handleFileDeletion(newFile, FILE_TYPE_TARGET);
                        Files.copy(backupFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        boolean bl = backupFileDeleteFailure = !this.handleFileDeletion(backupFile, FILE_TYPE_BACKUP);
                        if (newFileDeleteFailure || backupFileDeleteFailure) {
                            successful = false;
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        this.backupFailureMessage("copy", backupFile.getName(), targetFile.getName(), ExceptionUtils.getRootCauseMessage((Throwable)e));
                        successful = false;
                    }
                    continue;
                }
            }
            this.logger.info("Successfully restored backup and removed new file [{}].", (Object)jobResource.getNewFilename());
            JobResult log2 = new JobResult("adminTools.jobs.upload.batch.restore.file.success", JobResultLevel.INFO, new Object[]{jobResource.getNewFilename()});
            ((PackageUploadJobStatus)this.status).addLog(log2);
            this.progressManager.endStep((Object)this);
        }
        if (successful) {
            this.logger.info("Backup restored with success.");
            log = new JobResult("adminTools.jobs.upload.batch.restore.success", JobResultLevel.INFO, new Object[0]);
        } else {
            this.logger.info("There were issues while trying to restore the backup. Please consult the log.");
            log = new JobResult("adminTools.jobs.upload.batch.restore.fail", JobResultLevel.ERROR, new Object[0]);
        }
        ((PackageUploadJobStatus)this.status).addLog(log);
    }

    private boolean handleFileDeletion(File file, String fileType) {
        if (file != null) {
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException e) {
                this.backupFailureMessage(fileType, file.getName(), ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.progressManager.endStep((Object)this);
                return false;
            }
        }
        return true;
    }

    private void backupFailureMessage(String translation, String ... parameters) {
        String translationHint = String.format("adminTools.jobs.upload.batch.restore.%s.fail", translation);
        this.logger.warn(this.contextLocalization.getTranslationPlain(translationHint, (Object[])parameters));
        JobResult log = new JobResult(translationHint, JobResultLevel.ERROR, (Object[])parameters);
        ((PackageUploadJobStatus)this.status).addLog(log);
    }
}

