/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.security;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.admintools.internal.security.AbstractRightsProvider;
import com.xwiki.admintools.security.RightsResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.query.SecureQuery;
import org.xwiki.search.solr.SolrUtils;

@Component(roles={EntityRightsProvider.class})
@Singleton
public class EntityRightsProvider
extends AbstractRightsProvider {
    private static final String XWIKI = "XWiki";
    private static final String XWIKI_RIGHTS = "XWikiRights";
    private static final String XWIKI_SERVER_PREFIX = "XWikiServer";
    private static final String SPACE_TYPE = "Space";
    private static final String PAGE_TYPE = "Page";
    private static final String GLOBAL_TYPE = "Global";
    private static final String WIKI_KEY = "wikiName";
    private static final LocalDocumentReference GLOBAL_RIGHTS_CLASS = new LocalDocumentReference("XWiki", "XWikiGlobalRights");
    private static final LocalDocumentReference DOCUMENT_RIGHTS_CLASS = new LocalDocumentReference("XWiki", "XWikiRights");
    @Inject
    private DocumentReferenceResolver<SolrDocument> solrDocumentReferenceResolver;
    @Inject
    @Named(value="secure")
    private QueryManager secureQueryManager;
    @Inject
    private SolrUtils solrUtils;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private Logger logger;

    public List<RightsResult> getEntityRights(Map<String, String> filters, String sortColumn, String order, String entityType) {
        try {
            String rightsType = filters.get("type");
            this.logger.info("Getting the rights for entity [{}] and type [{}].", (Object)entityType, (Object)rightsType);
            HashSet<RightsResult> rightsResults = new HashSet<RightsResult>();
            switch (rightsType == null ? "" : rightsType) {
                case "Global": {
                    this.addGlobalRights(rightsResults, filters, entityType);
                    break;
                }
                case "Space": {
                    this.addRights(rightsResults, filters, GLOBAL_RIGHTS_CLASS, SPACE_TYPE, entityType);
                    break;
                }
                case "Page": {
                    this.addRights(rightsResults, filters, DOCUMENT_RIGHTS_CLASS, PAGE_TYPE, entityType);
                    break;
                }
                default: {
                    this.addGlobalRights(rightsResults, filters, entityType);
                    this.addRights(rightsResults, filters, GLOBAL_RIGHTS_CLASS, SPACE_TYPE, entityType);
                    this.addRights(rightsResults, filters, DOCUMENT_RIGHTS_CLASS, PAGE_TYPE, entityType);
                }
            }
            return this.applySort(rightsResults, sortColumn, order);
        }
        catch (Exception e) {
            this.logger.error("There was an error while processing the rights for entity [{}]: [{}]", (Object)entityType, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private void addGlobalRights(Set<RightsResult> rightsResults, Map<String, String> filters, String entityType) throws XWikiException {
        String wikiName = filters.get(WIKI_KEY);
        String docName = filters.get("docName");
        String space = filters.get("space");
        DocumentReference docReference = this.getGlobalRightsDocumentReference(wikiName);
        boolean docNameMatches = this.isMatchingIgnoreCase(docName, docReference.getName());
        boolean spaceMatches = this.isMatchingIgnoreCase(space, docReference.getLastSpaceReference().getName());
        if (docNameMatches && spaceMatches) {
            this.processDocumentRightsObjects(rightsResults, filters, GLOBAL_TYPE, docReference, GLOBAL_RIGHTS_CLASS, entityType);
        }
    }

    private DocumentReference getGlobalRightsDocumentReference(String wikiName) {
        return Optional.ofNullable(wikiName).filter(name -> !name.isEmpty() && !"-".equals(name)).map(name -> name.replace(XWIKI_SERVER_PREFIX, "").toLowerCase()).map(id -> this.documentReferenceResolver.resolve((Object)String.format("%s:XWiki.XWikiPreferences", id), new Object[0])).orElseGet(() -> this.documentReferenceResolver.resolve((Object)"XWiki.XWikiPreferences", new Object[0]));
    }

    private boolean isMatchingIgnoreCase(String filter, String targetValue) {
        return filter == null || filter.isEmpty() || targetValue.toLowerCase().contains(filter.toLowerCase());
    }

    private void addRights(Set<RightsResult> rightsResults, Map<String, String> filters, LocalDocumentReference rightsClassReference, String type, String entityType) throws QueryException, XWikiException {
        SolrDocumentList solrDocuments = this.getRightsForWiki(filters.get("docName"), filters.get("space"), filters.get(WIKI_KEY), type, rightsClassReference);
        for (SolrDocument solrDocument : solrDocuments) {
            DocumentReference docRef = this.solrDocumentReferenceResolver.resolve((Object)solrDocument, new Object[0]);
            this.processDocumentRightsObjects(rightsResults, filters, type, docRef, rightsClassReference, entityType);
        }
    }

    private void processDocumentRightsObjects(Set<RightsResult> rightsResults, Map<String, String> filters, String type, DocumentReference docReference, LocalDocumentReference rightsClassReference, String entityType) throws XWikiException {
        XWikiContext wikiContext = (XWikiContext)this.xcontextProvider.get();
        XWiki wiki = wikiContext.getWiki();
        XWikiDocument document = wiki.getDocument(docReference, wikiContext);
        this.logger.info("Getting rights from document [{}] and rights class [{}], for entity [{}].", new Object[]{document.getDocumentReference(), rightsClassReference, entityType});
        for (BaseObject object : document.getXObjects((EntityReference)rightsClassReference)) {
            if (object == null) continue;
            String entity = object.get(entityType).toFormString();
            String entityFilter = filters.get("entity");
            if (entity.isEmpty() || entityFilter != null && !entityFilter.isEmpty() && !wiki.getUserName(entity, null, false, wikiContext).trim().toLowerCase().contains(entityFilter.toLowerCase())) continue;
            RightsResult result = new RightsResult(type);
            result.setSpace(document.getDocumentReference().getLastSpaceReference().getName());
            result.setEntity(this.documentReferenceResolver.resolve((Object)entity, new Object[0]).toString());
            result.setLevel(object.get("levels").toFormString());
            result.setDocReference(document.getDocumentReference());
            result.setPolicy(object.get("allow").toFormString().equals("1") ? "Allowed" : "Denied");
            if (!this.checkFilters(filters, result)) continue;
            rightsResults.add(result);
        }
    }

    private SolrDocumentList getRightsForWiki(String searchedDocument, String searchedSpace, String wikiName, String type, LocalDocumentReference rightsClass) throws QueryException {
        Query query;
        ArrayList<String> filterStatements = new ArrayList<String>();
        if (searchedDocument != null && !searchedDocument.isEmpty()) {
            filterStatements.add(String.format("title_:%s", this.solrUtils.toCompleteFilterQueryString((Object)searchedDocument)));
        }
        if (searchedSpace != null && !searchedSpace.isEmpty()) {
            filterStatements.add(String.format("spaces:%s*", this.solrUtils.toCompleteFilterQueryString((Object)searchedSpace)));
        }
        if ((query = this.secureQueryManager.createQuery(String.format("type:DOCUMENT AND object:%s", rightsClass), "solr")) instanceof SecureQuery) {
            ((SecureQuery)query).checkCurrentAuthor(true);
            ((SecureQuery)query).checkCurrentUser(true);
        }
        String searchedWikiID = Optional.ofNullable(wikiName).filter(wiki -> !wiki.isEmpty() && !"-".equals(wiki)).map(wiki -> wiki.replace(XWIKI_SERVER_PREFIX, "").toLowerCase()).orElseGet(() -> ((XWikiContext)this.xcontextProvider.get()).getWikiId());
        filterStatements.add(String.format("wiki:%s", this.solrUtils.toCompleteFilterQueryString((Object)searchedWikiID)));
        filterStatements.add(type.equals(SPACE_TYPE) ? "-name:XWikiPreferences" : "hidden:false");
        query.bindValue("fl", (Object)"title_, reference, wiki, name, spaces");
        query.bindValue("fq", filterStatements);
        query.setLimit(200);
        return ((QueryResponse)query.execute().get(0)).getResults();
    }
}

