/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.security;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.licensing.Licensor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.template.TemplateManager;

@Component(roles={CheckSecurityCache.class})
@Singleton
public class CheckSecurityCache {
    private static final String ERROR_TEMPLATE = "licenseError.vm";
    private static final String NULL_VALUE = "null";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityEntryReader securityEntryReader;
    @Inject
    private SecurityReferenceFactory securityReferenceFactory;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private Provider<Licensor> licensorProvider;

    public String displaySecurityCheck(DocumentReference userRef, DocumentReference docRef) throws AuthorizationException {
        ArrayList<SecurityRuleEntry> cachedRuleEntries = new ArrayList<SecurityRuleEntry>();
        ArrayList<SecurityAccessEntry> cachedAccessEntries = new ArrayList<SecurityAccessEntry>();
        ArrayList<SecurityRuleEntry> ruleEntries = new ArrayList<SecurityRuleEntry>();
        UserSecurityReference userSecurityRef = this.securityReferenceFactory.newUserReference(userRef);
        this.addSecurityRules((EntityReference)docRef, userSecurityRef, cachedAccessEntries, cachedRuleEntries, ruleEntries);
        for (SpaceReference spaceRef : docRef.getSpaceReferences()) {
            this.addSecurityRules((EntityReference)spaceRef, userSecurityRef, cachedAccessEntries, cachedRuleEntries, ruleEntries);
        }
        this.addSecurityRules((EntityReference)docRef.getWikiReference(), userSecurityRef, cachedAccessEntries, cachedRuleEntries, ruleEntries);
        return this.renderTemplate(cachedRuleEntries, cachedAccessEntries, ruleEntries);
    }

    public Map<String, String> extractRuleUsersGroups(SecurityRule input) {
        LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
        Pattern pattern = Pattern.compile("(Users|Groups)=\\[(.*?)\\](?=,[A-Z]|$)");
        Matcher matcher = pattern.matcher(input.toString().replace(" ", ""));
        while (matcher.find()) {
            String key = matcher.group(1);
            String rawValue = matcher.group(2);
            String value = !rawValue.contains(NULL_VALUE) ? rawValue : rawValue.replace(NULL_VALUE, "XWikiGuest");
            keyValuePairs.put(key, value);
        }
        return keyValuePairs;
    }

    private void addSecurityRules(EntityReference docRef, UserSecurityReference userSecurityRef, List<SecurityAccessEntry> cachedAccessEntries, List<SecurityRuleEntry> cachedRuleEntries, List<SecurityRuleEntry> ruleEntries) throws AuthorizationException {
        SecurityReference docSecureRef = this.securityReferenceFactory.newEntityReference(docRef);
        SecurityRuleEntry cachedRuleEntry = this.securityCache.get(docSecureRef);
        SecurityAccessEntry cachedAccessEntry = this.securityCache.get(userSecurityRef, docSecureRef);
        SecurityRuleEntry securityRuleEntry = this.securityEntryReader.read(docSecureRef);
        cachedAccessEntries.add(cachedAccessEntry);
        cachedRuleEntries.add(cachedRuleEntry);
        ruleEntries.add(securityRuleEntry);
    }

    private String renderTemplate(List<SecurityRuleEntry> cachedRuleEntries, List<SecurityAccessEntry> cachedAccessEntries, List<SecurityRuleEntry> ruleEntries) {
        try {
            Licensor licensor = (Licensor)this.licensorProvider.get();
            String wiki = ((XWikiContext)this.xcontextProvider.get()).getWikiId();
            DocumentReference mainRef = new DocumentReference(wiki, Arrays.asList("AdminTools", "Code"), "ConfigurationClass");
            if (licensor == null || !licensor.hasLicensure((EntityReference)mainRef)) {
                return this.templateManager.render(ERROR_TEMPLATE);
            }
            ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
            scriptContext.setAttribute("cachedRuleEntries", cachedRuleEntries, 100);
            scriptContext.setAttribute("cachedAccessEntries", cachedAccessEntries, 100);
            scriptContext.setAttribute("ruleEntries", ruleEntries, 100);
            scriptContext.setAttribute("rights", Right.getStandardRights(), 100);
            return this.templateManager.render("securityCacheViewTemplate.vm");
        }
        catch (Exception e) {
            this.logger.warn("Failed to render custom template. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }
}

