/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.rest;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xwiki.admintools.internal.files.ImportantFilesManager;
import com.xwiki.admintools.internal.uploadJob.UploadJob;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import com.xwiki.admintools.jobs.PackageUploadJobRequest;
import com.xwiki.admintools.jobs.PackageUploadJobStatus;
import com.xwiki.admintools.rest.AdminToolsResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.rest.internal.resources.pages.ModifiablePageResource;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="com.xwiki.admintools.internal.rest.DefaultAdminToolsResource")
@Singleton
public class DefaultAdminToolsResource
extends ModifiablePageResource
implements AdminToolsResource {
    @Inject
    private Logger logger;
    @Inject
    private ImportantFilesManager importantFilesManager;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public Response getFile(String hint) {
        try {
            this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
            XWikiContext wikiContext = (XWikiContext)this.xcontextProvider.get();
            XWikiRequest xWikiRequest = wikiContext.getRequest();
            Map formParameters = xWikiRequest.getParameterMap();
            byte[] fileContent = this.importantFilesManager.getFile(hint, formParameters);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent);
            return Response.ok((Object)inputStream).type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        catch (AccessDeniedException deniedException) {
            this.logger.warn("Failed to get file from DataResource [{}] due to restricted rights.", (Object)hint);
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (IOException e) {
            this.logger.warn("Error while handling file from DataResource [{}]. Root cause: [{}]", (Object)hint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            this.logger.warn("Failed to get data from DataResource [{}]. Root cause: [{}]", (Object)hint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Response getFiles() {
        try {
            this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
            XWikiContext wikiContext = (XWikiContext)this.xcontextProvider.get();
            XWikiRequest xWikiRequest = wikiContext.getRequest();
            Map formParameters = xWikiRequest.getParameterMap();
            byte[] filesArchive = this.importantFilesManager.getFilesArchive(formParameters);
            return Response.ok((Object)filesArchive).type("application/zip").header("Content-Disposition", (Object)"attachment; filename=AdminToolsFiles.zip").build();
        }
        catch (AccessDeniedException deniedException) {
            this.logger.warn("Failed to get files due to restricted rights.");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (Exception e) {
            this.logger.warn("Failed to get zip archive. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Response flushCache() {
        try {
            this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
            this.contextualAuthorizationManager.checkAccess(Right.PROGRAM);
            XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
            XWiki xwiki = xwikiContext.getWiki();
            xwiki.flushCache(xwikiContext);
            return Response.ok().type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        catch (AccessDeniedException deniedException) {
            this.logger.warn("Failed to flush the cache due to restricted rights.");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (Exception e) {
            this.logger.warn("Failed to flush instance cache. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Response uploadPackageArchive(String attachReference, String startTime) {
        try {
            this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
            List<String> jobId = List.of("adminTools", "upload", attachReference, startTime);
            Job job = this.jobExecutor.getJob(jobId);
            if (job == null) {
                PackageUploadJobRequest packageUploadJobRequest = new PackageUploadJobRequest(attachReference, jobId);
                UploadJob uploadJob = (UploadJob)this.jobExecutor.execute("admintools.uploadpackage", (Request)packageUploadJobRequest);
                if (this.jobExecutor.getCurrentJob(uploadJob.getGroupPath()) != null) {
                    ((PackageUploadJobStatus)uploadJob.getStatus()).addLog(new JobResult("adminTools.jobs.upload.start.waiting", JobResultLevel.INFO, new Object[0]));
                }
                return Response.status((int)202).build();
            }
            return Response.status((int)102).build();
        }
        catch (AccessDeniedException deniedException) {
            this.logger.warn("Failed to begin the package upload due to insufficient rights.");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (Exception e) {
            this.logger.warn("Failed to begin package upload job. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

