/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.network;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xwiki.admintools.internal.network.HttpClientBuilderFactory;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.contrib.limits.LimitsConfiguration;

@Component(roles={NetworkManager.class})
@Singleton
public class NetworkManager
implements Initializable {
    private static final String COOKIE_ID = "xnngSessionId";
    private static final String COOKIE_KEY = "Cookie";
    private static final String INSTANCE_KEY = "instance";
    @Inject
    private Provider<XWikiContext> wikiContextProvider;
    @Inject
    private LimitsConfiguration limitsConfiguration;
    private String requestDomain;
    private String instanceReference = "";
    private String account;
    private String accountRef;
    private String instance;
    private long detail;
    @Inject
    private HttpClientBuilderFactory httpClientBuilderFactory;

    public void initialize() throws InitializationException {
        Map customLimits;
        XWikiRequest wikiRequest = ((XWikiContext)this.wikiContextProvider.get()).getRequest();
        String instanceDomain = wikiRequest.getRequestURL().toString().replace(wikiRequest.getRequestURI(), "");
        this.requestDomain = "xnng.xwiki.com";
        if (instanceDomain.endsWith("devxwiki.com")) {
            this.requestDomain = "xnng-staging.devxwiki.com";
        }
        if (!(customLimits = this.limitsConfiguration.getCustomLimits()).isEmpty()) {
            this.instanceReference = customLimits.get("instanceReference").toString();
            this.detail = ((Date)customLimits.get("expirationDate")).getTime();
            this.getSpecificFields(this.instanceReference);
        }
    }

    public Map<String, Object> getJSONFromNetwork(String target, Map<String, String> parameters, boolean useRef) throws IOException, InterruptedException {
        HttpClient client = this.httpClientBuilderFactory.getHttpClient();
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        boolean hasSession = wikiContext.getRequest().getSession().getAttribute(COOKIE_ID) != null;
        boolean hasAccess = hasSession ? this.checkAccess(client) : this.tryGetAccess(client);
        return hasAccess ? this.getJSON(target, parameters, client, useRef) : null;
    }

    public Map<String, Object> getLimits() throws IOException, InterruptedException {
        HttpClient client = this.httpClientBuilderFactory.getHttpClient();
        String targetPath = "xwiki/rest/instance/limits";
        URI uri = this.getURI(targetPath, Map.of(INSTANCE_KEY, this.instanceReference, "detail", String.valueOf(this.detail)));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            ObjectMapper objectMapper = new ObjectMapper();
            return (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return Collections.emptyMap();
    }

    private void getSpecificFields(String instanceReference) {
        Pattern pattern = Pattern.compile("Account_\\d+|Instance_\\d+");
        Matcher matcher = pattern.matcher(instanceReference);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.startsWith("Account_")) {
                this.account = match;
                this.accountRef = String.format("Accounts.%s.WebHome", match);
                continue;
            }
            if (!match.startsWith("Instance_")) continue;
            this.instance = match;
        }
    }

    private boolean checkAccess(HttpClient client) throws IOException, InterruptedException {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        String targetURL = String.format("https://%s/xwiki/bin/view/%s", this.requestDomain, this.instanceReference.replace(".", "/"));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(targetURL)).header(COOKIE_KEY, (String)wikiContext.getRequest().getSession().getAttribute(COOKIE_ID)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            return this.tryGetAccess(client);
        }
        return true;
    }

    private Map<String, Object> getJSON(String target, Map<String, String> parameters, HttpClient client, boolean useRef) throws IOException, InterruptedException {
        HashMap<String, String> completeParameters = new HashMap<String, String>(parameters);
        if (useRef) {
            completeParameters.put("accountReference", this.accountRef);
        } else {
            completeParameters.put("account", this.account);
            completeParameters.put(INSTANCE_KEY, this.instance);
        }
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        URI dataUri = this.getURI(target, completeParameters);
        HttpRequest dataRequest = HttpRequest.newBuilder().uri(dataUri).header(COOKIE_KEY, (String)wikiContext.getRequest().getSession().getAttribute(COOKIE_ID)).GET().build();
        HttpResponse<String> response = client.send(dataRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            ObjectMapper objectMapper = new ObjectMapper();
            return (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return Collections.emptyMap();
    }

    private URI getURI(String target, Map<String, String> parameters) {
        String uri = String.format("https://%s/%s", this.requestDomain, target);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)uri);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty() || entry.getValue().equals("-")) continue;
            uriBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        return uriBuilder.build(new Object[0]);
    }

    private boolean tryGetAccess(HttpClient client) throws IOException, InterruptedException {
        String targetURL = String.format("https://%s/xwiki/rest/user/instance/access?instance=%s&detail=%d", this.requestDomain, this.instanceReference, this.detail);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(targetURL)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
            List<String> setCookieHeaders = response.headers().map().get("set-cookie");
            String sessionCookie = "";
            if (setCookieHeaders != null) {
                for (String cookie : setCookieHeaders) {
                    if (!cookie.startsWith("JSESSIONID=")) continue;
                    sessionCookie = cookie.split(";", 2)[0];
                    break;
                }
            }
            wikiContext.getRequest().getSession().setAttribute(COOKIE_ID, (Object)sessionCookie);
            return true;
        }
        return false;
    }
}

