/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.job;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.health.HealthCheck;
import com.xwiki.admintools.jobs.HealthCheckJobRequest;
import com.xwiki.admintools.jobs.HealthCheckJobStatus;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;

@Component
@Named(value="admintools.healthcheck")
public class HealthCheckJob
extends AbstractJob<HealthCheckJobRequest, HealthCheckJobStatus>
implements GroupedJob {
    public static final String JOB_TYPE = "admintools.healthcheck";
    @Inject
    private Provider<List<HealthCheck>> healthChecks;
    @Inject
    private Provider<XWikiContext> wikiContextProvider;

    public String getType() {
        return JOB_TYPE;
    }

    public JobGroupPath getGroupPath() {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        String wikiId = wikiContext.getWikiId();
        return new JobGroupPath(List.of("adminTools", "healthCheck", wikiId));
    }

    protected HealthCheckJobStatus createNewStatus(HealthCheckJobRequest request) {
        return new HealthCheckJobStatus(JOB_TYPE, request, this.observationManager, this.loggerManager);
    }

    protected void runInternal() {
        List healthCheckList = (List)this.healthChecks.get();
        this.progressManager.pushLevelProgress(healthCheckList.size(), (Object)this);
        Iterator healthCheckIterator = healthCheckList.iterator();
        try {
            while (healthCheckIterator.hasNext()) {
                if (((HealthCheckJobStatus)this.status).isCanceled()) {
                    break;
                }
                this.progressManager.startStep((Object)this);
                JobResult checkResult = ((HealthCheck)healthCheckIterator.next()).check();
                ((HealthCheckJobStatus)this.status).getJobResults().add(checkResult);
                this.progressManager.endStep((Object)this);
                Thread.yield();
            }
        }
        catch (Exception e) {
            this.logger.error("An error occurred while running the health check.", (Throwable)e);
            ((HealthCheckJobStatus)this.status).getJobResults().add(new JobResult("adminTools.dashboard.healthcheck.execution.error", JobResultLevel.FAIL, new Object[0]));
            throw new RuntimeException(e);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

