/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.security;

import com.xwiki.admintools.internal.health.checks.security.AbstractSecurityHealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="configurationEncoding")
@Singleton
public class ConfigurationEncodingHealthCheck
extends AbstractSecurityHealthCheck {
    public static final String HINT = "configurationEncoding";

    public JobResult check() {
        String configEnc = this.getSecurityProviderJSON().get(HINT);
        if (configEnc == null) {
            this.logger.warn("Configuration encoding could not be detected!");
            return new JobResult("adminTools.dashboard.healthcheck.security.xwiki.config.notFound", JobResultLevel.WARN, new Object[0]);
        }
        boolean isConfigEncSafe = this.isSafeEncoding(configEnc, "XWiki configuration");
        if (!isConfigEncSafe) {
            return new JobResult("adminTools.dashboard.healthcheck.security.xwiki.config.warn", JobResultLevel.WARN, new Object[]{configEnc});
        }
        return new JobResult("adminTools.dashboard.healthcheck.security.xwiki.config.info", JobResultLevel.INFO, new Object[0]);
    }
}

