/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.security;

import com.xwiki.admintools.internal.health.checks.security.AbstractSecurityHealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="activeEncoding")
@Singleton
public class ActiveEncodingHealthCheck
extends AbstractSecurityHealthCheck {
    public static final String HINT = "activeEncoding";

    public JobResult check() {
        String activeEnc = this.getSecurityProviderJSON().get(HINT);
        if (activeEnc == null) {
            this.logger.warn("Active encoding could not be detected!");
            return new JobResult("adminTools.dashboard.healthcheck.security.xwiki.active.notFound", JobResultLevel.WARN, new Object[0]);
        }
        boolean isActiveEncSafe = this.isSafeEncoding(activeEnc, "XWiki active");
        if (!isActiveEncSafe) {
            return new JobResult("adminTools.dashboard.healthcheck.security.xwiki.active.warn", JobResultLevel.WARN, new Object[]{activeEnc});
        }
        return new JobResult("adminTools.dashboard.healthcheck.security.xwiki.active.info", JobResultLevel.INFO, new Object[0]);
    }
}

