/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.security;

import com.xwiki.admintools.DataProvider;
import com.xwiki.admintools.health.HealthCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public abstract class AbstractSecurityHealthCheck
implements HealthCheck {
    protected final List<String> acceptedEncodings = new ArrayList<String>(List.of("UTF8", "UTF-8", "utf8", "utf-8"));
    @Inject
    protected Logger logger;
    @Inject
    @Named(value="security")
    private DataProvider securityDataProvider;

    protected boolean isSafeEncoding(String encoding, String type) {
        if (this.acceptedEncodings.contains(encoding)) {
            return true;
        }
        this.logger.warn("[{}] encoding is [{}], but should be UTF-8!", (Object)type, (Object)encoding);
        return false;
    }

    protected Map<String, String> getSecurityProviderJSON() {
        try {
            return this.securityDataProvider.getDataAsJSON();
        }
        catch (Exception e) {
            this.logger.warn("Failed to generate the instance security data. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return new HashMap<String, String>();
        }
    }
}

