/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.performance;

import com.xwiki.admintools.health.HealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

@Component
@Named(value="cpuPerformance")
@Singleton
public class CPUHealthCheck
implements HealthCheck {
    public static final String HINT = "cpuPerformance";
    @Inject
    private Logger logger;

    public JobResult check() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        CentralProcessor processor = hardware.getProcessor();
        int cpuCores = processor.getPhysicalProcessorCount();
        int maxFreq = (int)(processor.getMaxFreq() / 0x100000L);
        if (cpuCores > 2 && maxFreq > 2048) {
            return new JobResult("adminTools.dashboard.healthcheck.performance.cpu.info", JobResultLevel.INFO, new Object[0]);
        }
        String cpuSpecifications = String.format("CPU cores %d - frequency %d", cpuCores, maxFreq);
        this.logger.warn("The CPU does not satisfy the minimum system requirements! [{}]", (Object)cpuSpecifications);
        return new JobResult("adminTools.dashboard.healthcheck.performance.cpu.warn", JobResultLevel.WARN, new Object[]{cpuCores, maxFreq});
    }
}

