/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.memory;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.health.HealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="memoryPhysical")
@Singleton
public class MemoryHealthCheck
implements HealthCheck {
    public static final String HINT = "memoryPhysical";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    public JobResult check() {
        XWiki wiki = ((XWikiContext)this.xcontextProvider.get()).getWiki();
        float maxMemory = wiki.maxMemory();
        float totalFreeMemory = (maxMemory - (float)(wiki.totalMemory() - wiki.freeMemory())) / 1048576.0f;
        float maxMemoryGB = maxMemory / 1.0737418E9f;
        DecimalFormat format = new DecimalFormat("0.#");
        if (maxMemoryGB < 1.0f) {
            this.logger.error("JVM memory is less than 1024MB. Currently: [{}]", (Object)Float.valueOf(maxMemoryGB * 1024.0f));
            return new JobResult("adminTools.dashboard.healthcheck.memory.maxcapacity.error", JobResultLevel.ERROR, new Object[]{Float.valueOf(maxMemoryGB * 1024.0f)});
        }
        if (totalFreeMemory < 512.0f) {
            this.logger.error("JVM instance has only [{}]MB free memory left!", (Object)Float.valueOf(totalFreeMemory));
            return new JobResult("adminTools.dashboard.healthcheck.memory.free.error", JobResultLevel.ERROR, new Object[]{Float.valueOf(totalFreeMemory)});
        }
        if (totalFreeMemory < 1024.0f) {
            this.logger.warn("Instance memory is running low. Currently only [{}]MB free left.", (Object)Float.valueOf(totalFreeMemory));
            return new JobResult("adminTools.dashboard.healthcheck.memory.free.warn", JobResultLevel.WARN, new Object[]{Float.valueOf(totalFreeMemory)});
        }
        return new JobResult("adminTools.dashboard.healthcheck.memory.info", JobResultLevel.INFO, new Object[]{Float.valueOf(totalFreeMemory / 1024.0f)});
    }
}

