/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.memory;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.health.HealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="memoryHeapAllocation")
@Singleton
public class HeapAllocationCheck
implements HealthCheck {
    public static final String HINT = "memoryHeapAllocation";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    public JobResult check() {
        XWiki wiki = ((XWikiContext)this.xcontextProvider.get()).getWiki();
        float maxMemory = (float)wiki.maxMemory() / 1048576.0f;
        float initialMemoryAllocation = (float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getInit() / 1048576.0f;
        if (initialMemoryAllocation != maxMemory) {
            this.logger.warn("To improve performance, -Xms  and -Xmx memory allocation should be identical.");
            return new JobResult("adminTools.dashboard.healthcheck.memory.allocation.warn", JobResultLevel.WARN, new Object[0]);
        }
        return new JobResult("adminTools.dashboard.healthcheck.memory.allocation.info", JobResultLevel.INFO, new Object[]{Float.valueOf(maxMemory / 1024.0f)});
    }
}

