/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.memory;

import com.xwiki.admintools.health.HealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;

@Component
@Named(value="memoryCache")
@Singleton
public class CacheMemoryHealthCheck
implements HealthCheck {
    public static final String HINT = "memoryCache";
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configurationSource;
    @Inject
    private Logger logger;

    public JobResult check() {
        String storeCacheCapacity = (String)this.configurationSource.getProperty("xwiki.store.cache.capacity");
        if (storeCacheCapacity == null) {
            this.logger.warn("Store cache capacity not defined. Set by default at 500.");
            return new JobResult("adminTools.dashboard.healthcheck.memory.cache.null", JobResultLevel.INFO, new Object[0]);
        }
        int cacheCapacity = Integer.parseInt(storeCacheCapacity);
        if (cacheCapacity < 500) {
            this.logger.warn("Store cache capacity is set to [{}].", (Object)storeCacheCapacity);
            return new JobResult("adminTools.dashboard.healthcheck.memory.cache.low", JobResultLevel.WARN, new Object[]{cacheCapacity});
        }
        return new JobResult("adminTools.dashboard.healthcheck.memory.cache.info", JobResultLevel.INFO, new Object[]{cacheCapacity});
    }
}

