/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.configuration;

import com.xwiki.admintools.internal.health.checks.configuration.AbstractConfigurationHealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="configurationOS")
@Singleton
public class ConfigurationOSHealthCheck
extends AbstractConfigurationHealthCheck {
    public static final String HINT = "configurationOS";

    public JobResult check() {
        Map<String, String> dataJSON = this.getConfigurationProviderJSON();
        if (dataJSON.get("osName") == null || dataJSON.get("osVersion") == null || dataJSON.get("osArch") == null) {
            this.logger.warn("There has been an error while gathering OS info!");
            return new JobResult("adminTools.dashboard.healthcheck.os.warn", JobResultLevel.WARN, new Object[0]);
        }
        return new JobResult("adminTools.dashboard.healthcheck.os.info", JobResultLevel.INFO, new Object[0]);
    }
}

