/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.configuration;

import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.internal.health.checks.configuration.AbstractConfigurationHealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="configurationDatabase")
@Singleton
public class ConfigurationDatabaseHealthCheck
extends AbstractConfigurationHealthCheck {
    public static final String HINT = "configurationDatabase";
    @Inject
    private CurrentServer currentServer;

    public JobResult check() {
        String usedDatabase = this.getConfigurationProviderJSON().get("databaseName");
        if (usedDatabase == null) {
            this.logger.warn("Database not found!");
            return new JobResult("adminTools.dashboard.healthcheck.database.warn", JobResultLevel.ERROR, new Object[0]);
        }
        if (this.currentServer.getSupportedDBs().stream().anyMatch(d -> usedDatabase.toLowerCase().contains(d.toLowerCase()))) {
            return new JobResult("adminTools.dashboard.healthcheck.database.info", JobResultLevel.INFO, new Object[0]);
        }
        this.logger.error("Used database is not supported!");
        return new JobResult("adminTools.dashboard.healthcheck.database.notSupported", JobResultLevel.ERROR, new Object[]{usedDatabase});
    }
}

