/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.files.resources;

import com.xwiki.admintools.DataProvider;
import com.xwiki.admintools.download.DataResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="dataProvider")
@Singleton
public class DataProvidersDataResource
implements DataResource {
    public static final String HINT = "dataProvider";
    @Inject
    private Provider<List<DataProvider>> dataProviders;
    @Inject
    private Logger logger;

    public void addZipEntry(ZipOutputStream zipOutputStream, Map<String, String[]> filters) {
        this.addZipEntry(zipOutputStream);
    }

    public byte[] getByteData(Map<String, String[]> params) throws Exception {
        HashMap<String, Map> providersResults = new HashMap<String, Map>();
        for (DataProvider dataProvider : (List)this.dataProviders.get()) {
            try {
                providersResults.put(dataProvider.getIdentifier(), dataProvider.getDataAsJSON());
            }
            catch (Exception e) {
                throw new Exception(String.format("Error while getting JSON data for [%s] DataProvider.", dataProvider.getIdentifier()), e);
            }
        }
        return ((Object)providersResults).toString().getBytes();
    }

    public String getIdentifier() {
        return HINT;
    }

    private void addZipEntry(ZipOutputStream zipOutputStream) {
        try {
            byte[] buffer = this.getByteData(null);
            ZipEntry zipEntry = new ZipEntry("configuration_json.txt");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(buffer, 0, buffer.length);
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            this.logger.warn("Could not add gathered configuration to the archive. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)exception));
        }
    }
}

