/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.files;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.download.DataResource;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.licensing.Licensor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.TemplateManager;

@Component(roles={ImportantFilesManager.class})
@Singleton
public class ImportantFilesManager {
    private static final String TEMPLATE_NAME = "filesSectionTemplate.vm";
    private static final String REQUESTED_FILES_KEY = "files";
    private static final String ERROR_TEMPLATE = "licenseError.vm";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private CurrentServer currentServer;
    @Inject
    private Logger logger;
    @Inject
    private Provider<Licensor> licensorProvider;

    public byte[] getFile(String hint, Map<String, String[]> params) throws Exception {
        DataResource fileViewerProvider = this.findDataResource(hint);
        if (fileViewerProvider == null) {
            throw new NullPointerException(String.format("Could not find a DataResource implementation for [%s].", hint));
        }
        try {
            return fileViewerProvider.getByteData(params);
        }
        catch (IOException e) {
            throw new IOException("Error while managing file.", e);
        }
        catch (Exception e) {
            throw new Exception("Error while processing file content.", e);
        }
    }

    public byte[] getFilesArchive(Map<String, String[]> params) throws Exception {
        byte[] throwable;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        try {
            for (String dataResourceHint : params.get(REQUESTED_FILES_KEY)) {
                DataResource archiver = this.findDataResource(dataResourceHint);
                Map<String, String[]> filteredParams = params.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(REQUESTED_FILES_KEY)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (archiver == null) continue;
                archiver.addZipEntry(zipOutputStream, filteredParams);
            }
            zipOutputStream.flush();
            byteArrayOutputStream.flush();
            zipOutputStream.close();
            byteArrayOutputStream.close();
            throwable = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    zipOutputStream.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (Exception e) {
                throw new Exception("Error while generating the files archive.", e);
            }
        }
        zipOutputStream.close();
        return throwable;
    }

    public String renderTemplate() {
        try {
            Licensor licensor = (Licensor)this.licensorProvider.get();
            String wiki = ((XWikiContext)this.xcontextProvider.get()).getWikiId();
            DocumentReference mainRef = new DocumentReference(wiki, Arrays.asList("AdminTools", "Code"), "ConfigurationClass");
            if (licensor == null || !licensor.hasLicensure((EntityReference)mainRef)) {
                return this.templateManager.render(ERROR_TEMPLATE);
            }
            boolean found = this.currentServer.getCurrentServer() != null;
            ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
            scriptContext.setAttribute("found", found, 100);
            return this.templateManager.render(TEMPLATE_NAME);
        }
        catch (Exception e) {
            this.logger.warn("Failed to render [{}] template. Root cause is: [{}]", (Object)TEMPLATE_NAME, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private DataResource findDataResource(String hint) throws ComponentLookupException {
        return (DataResource)this.contextComponentManager.getInstance(DataResource.class, hint);
    }
}

