/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.data.identifiers;

import com.xwiki.admintools.ServerInfo;
import com.xwiki.admintools.configuration.AdminToolsConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

public abstract class AbstractServerInfo
implements ServerInfo {
    protected List<String> serverCfgPossiblePaths = new ArrayList<String>();
    protected List<String> xwikiCfgPossiblePaths = new ArrayList<String>();
    protected List<String> xwikiInstallPossiblePaths = new ArrayList<String>();
    @Inject
    @Named(value="default")
    protected AdminToolsConfiguration adminToolsConfig;
    protected String serverPath;

    public String getServerPath() {
        return this.serverPath;
    }

    public String getServerCfgPath() {
        for (String serverCfgPath : this.serverCfgPossiblePaths) {
            if (!new File(serverCfgPath).exists()) continue;
            return serverCfgPath;
        }
        return null;
    }

    public String getXwikiCfgFolderPath() {
        for (String xwikiCfgFolderPath : this.xwikiCfgPossiblePaths) {
            if (!new File(xwikiCfgFolderPath + "xwiki.cfg").exists()) continue;
            return xwikiCfgFolderPath;
        }
        return null;
    }

    public String getXWikiInstallFolderPath() {
        String configurationPath = this.adminToolsConfig.getXWikiInstallLocation();
        if (new File(configurationPath).isDirectory()) {
            return configurationPath;
        }
        for (String xwikiLibraryFolderPath : this.xwikiInstallPossiblePaths) {
            if (!new File(xwikiLibraryFolderPath).isDirectory()) continue;
            return xwikiLibraryFolderPath;
        }
        return null;
    }
}

