/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.data;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.internal.data.AbstractDataProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;

@Component
@Named(value="security")
@Singleton
public class SecurityDataProvider
extends AbstractDataProvider {
    public static final String HINT = "security";
    private static final String WORK_DIRECTORY = "PWD";
    private static final String LANGUAGE = "LANG";
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configurationSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource properties;

    public String getRenderedData() {
        Map<Object, Object> securityDetails = new HashMap();
        try {
            securityDetails = this.getDataAsJSON();
            securityDetails.put("serverFound", "true");
        }
        catch (Exception e) {
            this.logger.warn("Failed to generate the instance security data. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            securityDetails.put("serverFound", "false");
        }
        return this.renderTemplate("securityTemplate.vm", securityDetails, HINT);
    }

    public String getIdentifier() {
        return HINT;
    }

    public Map<String, String> getDataAsJSON() throws Exception {
        try {
            Map<String, String> securityDetails = this.getXwikiSecurityInfo();
            securityDetails.putAll(this.getEnvironmentInfo());
            securityDetails.put("fileEncoding", System.getProperty("file.encoding"));
            return securityDetails;
        }
        catch (Exception e) {
            throw new Exception("Failed to generate the instance security data.", e);
        }
    }

    private Map<String, String> getXwikiSecurityInfo() throws Exception {
        try {
            HashMap<String, String> results = new HashMap<String, String>();
            XWikiContext wikiContext = (XWikiContext)this.xcontextProvider.get();
            results.put("activeEncoding", wikiContext.getWiki().getEncoding());
            results.put("configurationEncoding", (String)this.configurationSource.getProperty("xwiki.encoding", String.class));
            return results;
        }
        catch (Exception e) {
            throw new Exception("Failed to generate xwiki security info.", e);
        }
    }

    private Map<String, String> getEnvironmentInfo() {
        HashMap<String, String> results = new HashMap<String, String>();
        String workDirectory = System.getenv(WORK_DIRECTORY);
        String language = System.getenv(LANGUAGE);
        if (workDirectory == null || language == null) {
            this.logger.info("Failed to access language or work directory environment variables. Attempting to retrieve data from Locale and properties.");
        }
        if (language == null) {
            language = Locale.getDefault().toString();
        }
        if (workDirectory == null) {
            String permDir = (String)this.properties.getProperty("environment.permanentDirectory");
            workDirectory = permDir != null ? permDir : "N/A";
        }
        results.put(WORK_DIRECTORY, workDirectory);
        results.put(LANGUAGE, language);
        return results;
    }
}

