/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.data;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.DataProvider;
import com.xwiki.licensing.Licensor;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.TemplateManager;

public abstract class AbstractDataProvider
implements DataProvider {
    protected static final String SERVER_FOUND = "serverFound";
    private static final String ERROR_TEMPLATE = "licenseError.vm";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected Logger logger;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private Provider<Licensor> licensorProvider;

    protected String renderTemplate(String template, Map<String, String> data, String hint) {
        try {
            Licensor licensor = (Licensor)this.licensorProvider.get();
            String wiki = ((XWikiContext)this.xcontextProvider.get()).getWikiId();
            DocumentReference mainRef = new DocumentReference(wiki, Arrays.asList("AdminTools", "Code"), "ConfigurationClass");
            if (licensor == null || !licensor.hasLicensure((EntityReference)mainRef)) {
                return this.templateManager.render(ERROR_TEMPLATE);
            }
            ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
            scriptContext.setAttribute(hint, data, 100);
            return this.templateManager.render(template);
        }
        catch (Exception e) {
            this.logger.warn("Failed to render custom template. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }
}

