/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="AdminToolsUninstallListener")
@Singleton
public class AdminToolsUninstallListener
extends AbstractEventListener {
    public static final String HINT = "AdminToolsUninstallListener";
    @Inject
    protected Logger logger;
    @Inject
    private Provider<XWikiContext> wikiContextProvider;
    @Inject
    private InstalledExtensionRepository installedRepository;

    public AdminToolsUninstallListener() {
        super(HINT, new Event[]{new ExtensionUninstalledEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof ExtensionUninstalledEvent) {
            try {
                ExtensionId uninstalledExtension = ((ExtensionUninstalledEvent)event).getExtensionId();
                if (uninstalledExtension.getId().equals(this.getAdminToolsExtensionId("ui"))) {
                    ExtensionId apiExtensionId = new ExtensionId(this.getAdminToolsExtensionId("api"), uninstalledExtension.getVersion());
                    ExtensionId defaultExtensionId = new ExtensionId(this.getAdminToolsExtensionId("default"), uninstalledExtension.getVersion());
                    InstalledExtension apiExtension = this.installedRepository.getInstalledExtension(apiExtensionId);
                    InstalledExtension defaultExtension = this.installedRepository.getInstalledExtension(defaultExtensionId);
                    String namespace = new WikiNamespace(((XWikiContext)this.wikiContextProvider.get()).getWikiId()).serialize();
                    this.logger.info("Attempting to uninstall Admin Tools default module...");
                    this.installedRepository.uninstallExtension(defaultExtension, namespace);
                    this.logger.info("Attempting to uninstall Admin Tools API module...");
                    this.installedRepository.uninstallExtension(apiExtension, namespace);
                    this.logger.info("Successfully uninstalled all Admin Tools modules.");
                }
            }
            catch (UninstallException e) {
                this.logger.error("There was an error while uninstalling Admin Tools modules. Root cause is: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                throw new RuntimeException(e);
            }
        }
    }

    private String getAdminToolsExtensionId(String module) {
        return String.format("com.xwiki.admintools:application-admintools-%s", module);
    }
}

