/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="AdminToolsEventListener")
@Singleton
public class AdminToolsEventListener
extends AbstractEventListener {
    public static final String HINT = "AdminToolsEventListener";
    private static final List<String> SPACE = Arrays.asList("AdminTools", "Code");
    private static final LocalDocumentReference CONFIG_DOC = new LocalDocumentReference(SPACE, "Configuration");
    @Inject
    private WikiDescriptorManager wikiManager;
    @Inject
    private Provider<CurrentServer> currentServer;

    public AdminToolsEventListener() {
        super(HINT, new Event[]{new DocumentUpdatedEvent(), new DocumentDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document;
        if ((event instanceof DocumentUpdatedEvent || event instanceof DocumentDeletedEvent) && (document = (XWikiDocument)source) != null && this.isAdminToolsConfigObject(document)) {
            ((CurrentServer)this.currentServer.get()).updateCurrentServer();
        }
    }

    private boolean isAdminToolsConfigObject(XWikiDocument doc) {
        DocumentReference configReference = new DocumentReference(CONFIG_DOC, this.getCurrentWikiReference());
        return Objects.equals(doc.getDocumentReference(), configReference);
    }

    private WikiReference getCurrentWikiReference() {
        return new WikiReference(this.wikiManager.getCurrentWikiId());
    }
}

